DIM gl_axisspeed AS FLOAT
DIM gl_axismodifer AS FLOAT

FUNCTION setupaxes(stepspermm AS FLOAT)
    VP_MODE=0
    FOR axiscount = 0 TO TABLE(comms_numaxes)-1
        BASE(axiscount)
        MERGE=ON
        UNITS = 16
        IF axiscount = 0 THEN
            'UNITS = 16 * (1/1.27)
            'Should only be doing this for MachType=ROUTER2600) Or (MachType=ROUTER2600PRO) Or (MachType=ROUTER2600ATC)
            IF (VR(vr_machine) = router2600) OR (VR(vr_machine) = router2600pro) OR (VR(vr_machine) = router2600atc) _
                THEN
                STEP_RATIO(100,127)
            ELSE
                STEP_RATIO(100,100)
            ENDIF
        ELSEIF axiscount = 3 THEN
            STEP_RATIO(100,100)
        ENDIF
        ATYPE = 43
        SPEED = 400 * stepspermm
'        IF (VR(vr_machine) = vmc1300) OR (VR(vr_machine) = vmc1300pro) THEN
'            ACCEL = 200 * stepspermm
 '           DECEL = 200 * stepspermm
 '       ELSE
 '           ACCEL = 600 * stepspermm
 '           DECEL = 600 * stepspermm
 '       ENDIF
        ACCEL = TABLE(comms_accelprogram)
        DECEL = TABLE(comms_accelprogram)
        CREEP = 4 * stepspermm
        SRAMP = 10

        IN_POS_DIST = 0.1
        IN_POS_SPEED = 0.1

        SELECT_CASE axiscount
            CASE 0
                FS_LIMIT = TABLE(comms_xpluslimit)
                RS_LIMIT = TABLE(comms_xminuslimit)
            CASE 1
                FS_LIMIT = TABLE(comms_ypluslimit)
                RS_LIMIT = TABLE(comms_yminuslimit)
            CASE 2
                FS_LIMIT = TABLE(comms_zpluslimit)
                RS_LIMIT = TABLE(comms_zminuslimit)
        END_CASE


        SERVO = 1
        WDOG = 1
        DEFPOS(0)
    NEXT axiscount

ENDFUNC

FUNCTION setspindlespeed(actual AS FLOAT)
'    DIM actual AS FLOAT
 '   actual = TABLE(comms_speed)

    DIM modifier AS FLOAT
    modifier = TABLE(table_speedoverride)/100

    actual = actual * modifier

    IF (actual > TABLE(comms_maxspeed)) THEN
        actual = TABLE(comms_maxspeed)
    ELSEIF (actual < TABLE(comms_minspeed)) THEN
        actual = TABLE(comms_minspeed)
    ENDIF

    IF (VR(vr_machine) = micromillpro) THEN'Micromill Pro needs an adjustment on its spindlespeed.
        actual = (actual + 179.69) / 1.0794
    ELSEIF (VR(vr_machine) = vmc1300) THEN'VMC 1300 needs an adjustment on its spindlespeed.
        actual = (actual + 194.71) / 1.7253
    ENDIF


    'full rad

    DIM finalspeed AS FLOAT
    finalspeed = 2048*(actual/TABLE(comms_maxspeed))
    IF finalspeed > 2048 THEN
        finalspeed = 2048
    ELSEIF finalspeed < 0 THEN
        finalspeed = 0
    ENDIF
    TABLE(106, finalspeed)

    SERVO AXIS(0)=OFF
    DAC AXIS(0)=finalspeed

    raiseevent(comms_speedoverride)
ENDFUNC

FUNCTION setfeedspeed()
'    DIM foundhome AS BOOLEAN
'    foundhome = FALSE
 '   FOR axiscount = 0 TO TABLE(comms_numaxes)-1
 '       BASE(axiscount)
 '       IF (MTYPE = 12) THEN
 '           foundhome = TRUE
 '       ENDIFa
 '   NEXT axiscount

 '   IF foundhome THEN
 '       WAIT UNTIL IDLE
 '   ENDIF

'    IF (TABLE(table_eventhoming) = 1) THEN
 '       RETURN
 '   ENDIF




    DIM actual AS FLOAT

    modifier = TABLE(table_feedoverride)/100

    'Check if the door is open. If it is then set feed to be very slow for safety
    IF TABLE(table_dooropen) = ON THEN
    'IF (NOT IN(input_guardclosed)) THEN
        actual = 200 * TABLE(comms_steppermm) / 60
    ELSE
        actual = TABLE(comms_feed)
    ENDIF

    IF (actual > 0) THEN

        IF (TABLE(table_eventhoming) = 1) THEN
            modifier = 1
        ELSEIF (modifier * actual) > TABLE(comms_maxfeed) THEN
            modifier = TABLE(comms_maxfeed) / actual
        ENDIF

        FOR axiscount=0 TO TABLE(comms_numaxes)-1
            BASE(axiscount)
            SPEED = actual
            FORCE_SPEED = SPEED
            ENDMOVE_SPEED = SPEED
            LOOKAHEAD_FACTOR = modifier
        NEXT axiscount
    ELSE
        FOR axiscount=0 TO TABLE(comms_numaxes)-1
            BASE(axiscount)

            LOOKAHEAD_FACTOR = 0
        NEXT axiscount
    ENDIF

    TABLE(table_speedrequest,0)

 '   DIM modifier AS FLOAT
 '   modifier = TABLE(table_feedoverride)/100


 '   DIM finalfeed AS FLOAT
 '   finalfeed = actual * modifier

 '   IF finalfeed > TABLE(comms_maxfeed) THEN
 '       finalfeed = TABLE(comms_maxfeed)
 '   ENDIF


 '   FOR axiscount=0 TO TABLE(comms_numaxes)-1
 '       BASE(axiscount)
 '       SPEED = finalfeed
 '   NEXT axiscount

 '   FORCE_SPEED = SPEED
 '   ENDMOVE_SPEED = SPEED

    raiseevent(comms_feedoverride)

ENDFUNC

FUNCTION ismachinesafe() AS BOOLEAN
    DIM dooropen AS BOOLEAN
    dooropen = TABLE(table_dooropen)

    DIM estoppressed AS BOOLEAN
    estoppressed = TABLE(table_estoppressed)

    RETURN (dooropen = OFF) AND (estoppressed = OFF)
ENDFUNC

FUNCTION raiseevent(event AS INTEGER)
    IF TABLE(table_applistening) > 0 THEN
        REPEAT
            WA(100)
        UNTIL TABLE(table_eventupdate)=0
        TABLE(table_eventupdate, event)
    ENDIF

ENDFUNC

FUNCTION checkisidle() AS BOOLEAN
    DIM idlecheck AS BOOLEAN
    idlecheck = IDLE AXIS(0) AND IDLE AXIS(1)
    IF (TABLE(comms_numaxes) >= 3) THEN
        idlecheck = idlecheck AND IDLE AXIS(2)
    ENDIF
    IF (TABLE(comms_numaxes) >= 4) THEN
        idlecheck = idlecheck AND IDLE AXIS(3)
    ENDIF

    TABLE(table_idletesting,0)
    TABLE(table_idle, idlecheck)
    RETURN idlecheck
ENDFUNC

FUNCTION getposition()
    TABLE(table_xpos, MPOS AXIS(0))
    TABLE(table_ypos, MPOS AXIS(1))
    TABLE(table_zpos, MPOS AXIS(2))
    TABLE(table_ivpos, MPOS AXIS(3))
ENDFUNC

FUNCTION homeaxis(axisno AS INTEGER)
    BASE(axisno)
    DATUM(3)
    BASE(0)
ENDFUNC

FUNCTION cyclereset() AS BOOLEAN
    DIM cyclecheck AS BOOLEAN
    cyclecheck = (TABLE(comms_reset) > 0) OR (TABLE(table_estoppressed) > 0)
    RETURN cyclecheck
    'RETURN FALSE
ENDFUNC

FUNCTION checkavailableairpressure() AS BOOLEAN
    RETURN IN(input_airpressure) = ON
ENDFUNC

FUNCTION notinauto() AS BOOLEAN
    RETURN NOT ((TABLE(comms_mode) = 2) OR (TABLE(comms_mode) = 3)) ' not if in AUTO or MDI
ENDFUNC

FUNCTION vmcnumberoftools() AS INTEGER
    IF IN(input_8postoolchanger) = ON THEN
        RETURN 8
    ELSE
        RETURN 6
    ENDIF
ENDFUNC
